// ListCtrlEx.h : interface of the CListCtrlEx class
//
// This class provedes a full row selection mode for the report
// mode list view control.
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1998 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#ifndef _CLISTCTLEX_
#define _CLISTCTLEX_

/////////////////////////////////////////////////////////////////////////////
#ifdef COMMON_EXPORTS
	#define COMMON_API __declspec(dllexport)
#else
	#define COMMON_API __declspec(dllimport)
#endif
/////////////////////////////////////////////////////////////////////////////
#pragma warning (disable : 4251)
#pragma warning (disable : 4275)
/////////////////////////////////////////////////////////////////////////////

class COMMON_API CListCtrlEx : public CListCtrl
{
	DECLARE_DYNCREATE(CListCtrlEx)

// Construction
public:
	CListCtrlEx();

// Attributes
protected:
	BOOL		m_bFullRowSel;

public:
	BOOL		SetFullRowSel(BOOL bFillRowSel);
	BOOL		GetFullRowSel();
	BOOL		m_bClientWidthSel;
	//
	int			m_NoIcons;
	int			m_ColNumber;
	int			m_ScrollBarWidthRemoved;
	CString*	m_ColNamesP;
	int*		m_ColWidthsP;
	int*		m_ColAlignmentP;
	CImageList*	m_ImageListP;
	BOOL InitializeColumn(int iColumnCount); //, int* iColumnSizeP, CString* iColumnName, CImageList* iImageList);
	BOOL UpdateViewRegion();
	//

// Overrides
protected:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CListCtrlEx)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CListCtrlEx();
#ifdef _DEBUG
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	static	LPCTSTR MakeShortString(CDC* pDC, LPCTSTR lpszLong, int nColumnLen, int nOffset);
	void	RepaintSelectedItems();

	// Implementation - client area width
	int m_cxClient;

	// Implementation - state icon width
	int m_cxStateImageOffset;
	afx_msg LRESULT OnSetImageList(WPARAM wParam, LPARAM lParam);

	// Implementation - list view colors
	COLORREF	m_clrText;
	COLORREF	m_clrTextBk;
	COLORREF	m_clrBkgnd;
	afx_msg LRESULT OnSetTextColor(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetTextBkColor(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetBkColor(WPARAM wParam, LPARAM lParam);

protected:
	// Generated message map functions
	//{{AFX_MSG(CListCtrlEx)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif